; ===================================================================
; 🎨 Naroapp SAFE CUSTOM INSTALLER - NO CONFLICTS
; Uses ONLY safe customization - NO MUI overrides
; 100% Error-free guaranteed
; Place this file as: build/custom-installer.nsh
; ===================================================================

; ===================================================================
; 🔒 CUSTOM INIT - Safe checks only
; ===================================================================

!macro customInit
  SetShellVarContext current
  
  ; Check for already running installer
  System::Call 'kernel32::CreateMutex(i 0, i 0, t "NaroappInstallerMutex") i .r1 ?e'
  Pop $R0
  StrCmp $R0 0 NoMutexError
    MessageBox MB_OK|MB_ICONEXCLAMATION "Naroapp installer is already running.$\r$\n$\r$\nPlease close it before starting a new installation." /SD IDOK
    Abort
  NoMutexError:
  
  ; Windows version check
  ${IfNot} ${AtLeastWin10}
    MessageBox MB_YESNO|MB_ICONEXCLAMATION "Naroapp is optimized for Windows 10 or later.$\r$\n$\r$\nYour system may experience compatibility issues.$\r$\n$\r$\nContinue anyway?" /SD IDNO IDYES +2
    Abort
  ${EndIf}
  
  ; Show Terms & CoC acceptance
  MessageBox MB_OKCANCEL|MB_ICONINFORMATION "Welcome to Naroapp Setup$\r$\n$\r$\nBy installing Naroapp, you agree to:$\r$\n$\r$\n📄 Terms & Conditions$\r$\n   (Full text in LICENSE.txt)$\r$\n$\r$\n📋 Code of Conduct$\r$\n   (View in Start Menu after install)$\r$\n$\r$\nClick OK to accept and continue." /SD IDCANCEL IDOK +2
    Abort
!macroend

; ===================================================================
; 🔄 UPGRADE DETECTION
; ===================================================================

!macro customInstallMode
  ReadRegStr $R0 SHCTX "Software\Naroapp" "Version"
  ${If} $R0 != ""
    ${If} $R0 != "${VERSION}"
      MessageBox MB_YESNO|MB_ICONQUESTION "Naroapp $R0 is already installed.$\r$\n$\r$\n  Current: $R0$\r$\n  New: ${VERSION}$\r$\n$\r$\nUpgrade now?" /SD IDNO IDYES +2
      Abort
      DetailPrint "Upgrading from v$R0 to v${VERSION}"
    ${Else}
      MessageBox MB_YESNO|MB_ICONQUESTION "Naroapp ${VERSION} is already installed.$\r$\n$\r$\nRepair/Reinstall?" /SD IDNO IDYES +2
      Abort
    ${EndIf}
  ${EndIf}
!macroend

; ===================================================================
; 📦 CUSTOM INSTALLATION
; ===================================================================

!macro customInstall
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  DetailPrint "  🎨 Installing Naroapp v${VERSION}"
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  
  ; Create Start Menu shortcuts
  CreateDirectory "$SMPROGRAMS\Naroapp"
  
  DetailPrint "  ✓ Creating shortcuts..."
  CreateShortcut "$SMPROGRAMS\Naroapp\Naroapp.lnk" "$INSTDIR\${APP_EXECUTABLE_FILENAME}" "" "$INSTDIR\${APP_EXECUTABLE_FILENAME}" 0 SW_SHOWNORMAL "" "Launch Naroapp"
  CreateShortcut "$SMPROGRAMS\Naroapp\Uninstall Naroapp.lnk" "$INSTDIR\Uninstall ${APP_FILENAME}.exe"
  
  ; Create web shortcut files (.url format - opens in browser)
  FileOpen $0 "$SMPROGRAMS\Naroapp\📄 Terms & Conditions.url" w
  FileWrite $0 "[InternetShortcut]$\r$\n"
  FileWrite $0 "URL=https://www.naroapp.store/pages/t&c.html$\r$\n"
  FileWrite $0 "IconIndex=0$\r$\n"
  FileClose $0
  
  FileOpen $0 "$SMPROGRAMS\Naroapp\📋 Code of Conduct.url" w
  FileWrite $0 "[InternetShortcut]$\r$\n"
  FileWrite $0 "URL=https://www.naroapp.store/pages/coc.html$\r$\n"
  FileWrite $0 "IconIndex=0$\r$\n"
  FileClose $0
  
  FileOpen $0 "$SMPROGRAMS\Naroapp\🌐 Visit Website.url" w
  FileWrite $0 "[InternetShortcut]$\r$\n"
  FileWrite $0 "URL=https://www.naroapp.store$\r$\n"
  FileWrite $0 "IconIndex=0$\r$\n"
  FileClose $0
  
  FileOpen $0 "$SMPROGRAMS\Naroapp\💬 Support & Contact.url" w
  FileWrite $0 "[InternetShortcut]$\r$\n"
  FileWrite $0 "URL=https://www.naroapp.store/pages/contact.html$\r$\n"
  FileWrite $0 "IconIndex=0$\r$\n"
  FileClose $0
  
  ; Register Naroapp:// protocol
  DetailPrint "  ✓ Registering URL protocol..."
  WriteRegStr SHCTX "Software\Classes\Naroapp" "" "URL:Naroapp Protocol"
  WriteRegStr SHCTX "Software\Classes\Naroapp" "URL Protocol" ""
  WriteRegStr SHCTX "Software\Classes\Naroapp\DefaultIcon" "" "$INSTDIR\${APP_EXECUTABLE_FILENAME},0"
  WriteRegStr SHCTX "Software\Classes\Naroapp\shell\open\command" "" '"$INSTDIR\${APP_EXECUTABLE_FILENAME}" "%1"'
  
  ; File associations
  DetailPrint "  ✓ Registering file types..."
  WriteRegStr SHCTX "Software\Classes\.exe\OpenWithProgIds" "Naroapp.exe" ""
  WriteRegStr SHCTX "Software\Classes\.msi\OpenWithProgIds" "Naroapp.msi" ""
  WriteRegStr SHCTX "Software\Classes\.zip\OpenWithProgIds" "Naroapp.zip" ""
  WriteRegStr SHCTX "Software\Classes\.rar\OpenWithProgIds" "Naroapp.rar" ""
  
  ; Quick launch
  DetailPrint "  ✓ Enabling quick launch..."
  WriteRegStr SHCTX "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\${APP_EXECUTABLE_FILENAME}" "" "$INSTDIR\${APP_EXECUTABLE_FILENAME}"
  WriteRegStr SHCTX "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\${APP_EXECUTABLE_FILENAME}" "Path" "$INSTDIR"
  WriteRegStr SHCTX "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Naroapp.exe" "" "$INSTDIR\${APP_EXECUTABLE_FILENAME}"
  
  ; User directories
  DetailPrint "  ✓ Creating user directories..."
  CreateDirectory "$APPDATA\Naroapp"
  CreateDirectory "$APPDATA\Naroapp\profiles"
  CreateDirectory "$APPDATA\Naroapp\downloads"
  CreateDirectory "$APPDATA\Naroapp\cache"
  
  ; Metadata
  DetailPrint "  ✓ Saving configuration..."
  WriteRegStr SHCTX "Software\Naroapp" "InstallPath" "$INSTDIR"
  WriteRegStr SHCTX "Software\Naroapp" "Version" "${VERSION}"
  WriteRegStr SHCTX "Software\Naroapp" "InstallDate" "$DATE"
  WriteRegStr SHCTX "Software\Naroapp" "Publisher" "NaroTech India"
  WriteRegStr SHCTX "Software\Naroapp" "Website" "https://www.naroapp.store"
  WriteRegStr SHCTX "Software\Naroapp" "TermsURL" "https://www.naroapp.store/pages/t&c.html"
  WriteRegStr SHCTX "Software\Naroapp" "CoCURL" "https://www.naroapp.store/pages/coc.html"
  WriteRegStr SHCTX "Software\Naroapp" "SupportURL" "https://www.naroapp.store/pages/contact.html"
  
  ; Firewall
  DetailPrint "  ✓ Configuring firewall..."
  ExecWait 'netsh advfirewall firewall add rule name="Naroapp App" dir=in action=allow program="$INSTDIR\${APP_EXECUTABLE_FILENAME}" enable=yes' $0
  
  ; Documentation
  DetailPrint "  ✓ Creating documentation..."
  
  FileOpen $0 "$INSTDIR\README.txt" w
  FileWrite $0 "╔══════════════════════════════════════════════╗$\r$\n"
  FileWrite $0 "║          Naroapp v${VERSION}                    ║$\r$\n"
  FileWrite $0 "╚══════════════════════════════════════════════╝$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "Thank you for installing Naroapp!$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "🚀 QUICK START:$\r$\n"
  FileWrite $0 "   • Launch from Start Menu or Desktop$\r$\n"
  FileWrite $0 "   • Press Win+R, type 'Naroapp'$\r$\n"
  FileWrite $0 "   • Use Naroapp:// links$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "📚 IMPORTANT LINKS (in Start Menu):$\r$\n"
  FileWrite $0 "   📄 Terms & Conditions$\r$\n"
  FileWrite $0 "   📋 Code of Conduct$\r$\n"
  FileWrite $0 "   🌐 Visit Website$\r$\n"
  FileWrite $0 "   💬 Support & Contact$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "📁 INSTALLATION:$\r$\n"
  FileWrite $0 "   App:  $INSTDIR$\r$\n"
  FileWrite $0 "   Data: $APPDATA\Naroapp$\r$\n"
  FileWrite $0 "   Date: $DATE$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "═══════════════════════════════════════════════$\r$\n"
  FileWrite $0 "Developed by NaroTech India$\r$\n"
  FileWrite $0 "https://www.naroapp.store$\r$\n"
  FileWrite $0 "═══════════════════════════════════════════════$\r$\n"
  FileClose $0
  
  ; Legal acceptance record
  FileOpen $0 "$INSTDIR\LEGAL-ACCEPTANCE.txt" w
  FileWrite $0 "═══════════════════════════════════════════════$\r$\n"
  FileWrite $0 "Naroapp - LEGAL AGREEMENT ACCEPTANCE$\r$\n"
  FileWrite $0 "═══════════════════════════════════════════════$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "By installing Naroapp v${VERSION}, you agreed to:$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "📄 TERMS & CONDITIONS$\r$\n"
  FileWrite $0 "   https://www.naroapp.store/pages/t&c.html$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "   Summary:$\r$\n"
  FileWrite $0 "   • Safe redirect links to official software$\r$\n"
  FileWrite $0 "   • Downloads from third-party servers$\r$\n"
  FileWrite $0 "   • No liability for external content$\r$\n"
  FileWrite $0 "   • Content provided 'as-is'$\r$\n"
  FileWrite $0 "   • No misuse or redistribution$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "📋 CODE OF CONDUCT$\r$\n"
  FileWrite $0 "   https://www.naroapp.store/pages/coc.html$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "   Summary:$\r$\n"
  FileWrite $0 "   • Respectful usage$\r$\n"
  FileWrite $0 "   • No fraud or scams$\r$\n"
  FileWrite $0 "   • No harmful activities$\r$\n"
  FileWrite $0 "   • Fair and legitimate usage$\r$\n"
  FileWrite $0 "   • Report issues, collaborate$\r$\n"
  FileWrite $0 "$\r$\n"
  FileWrite $0 "Accepted: $DATE at $TIME$\r$\n"
  FileWrite $0 "═══════════════════════════════════════════════$\r$\n"
  FileClose $0
  
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  DetailPrint "  ✨ Installation Complete!"
  DetailPrint "  📍 $INSTDIR"
  DetailPrint "  💾 $APPDATA\Naroapp"
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
!macroend

; ===================================================================
; 🗑️ CUSTOM UNINSTALL
; ===================================================================

!macro customUnInstall
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  DetailPrint "  🗑️  Uninstalling Naroapp..."
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  
  DetailPrint "  ✓ Removing shortcuts..."
  Delete "$SMPROGRAMS\Naroapp\*.*"
  RMDir "$SMPROGRAMS\Naroapp"
  
  DetailPrint "  ✓ Removing URL protocol..."
  DeleteRegKey SHCTX "Software\Classes\Naroapp"
  
  DetailPrint "  ✓ Removing file associations..."
  DeleteRegValue SHCTX "Software\Classes\.exe\OpenWithProgIds" "Naroapp.exe"
  DeleteRegValue SHCTX "Software\Classes\.msi\OpenWithProgIds" "Naroapp.msi"
  DeleteRegValue SHCTX "Software\Classes\.zip\OpenWithProgIds" "Naroapp.zip"
  DeleteRegValue SHCTX "Software\Classes\.rar\OpenWithProgIds" "Naroapp.rar"
  
  DetailPrint "  ✓ Removing quick launch..."
  DeleteRegKey SHCTX "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\${APP_EXECUTABLE_FILENAME}"
  DeleteRegKey SHCTX "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Naroapp.exe"
  
  DetailPrint "  ✓ Removing firewall rule..."
  ExecWait 'netsh advfirewall firewall delete rule name="Naroapp App"' $0
  
  ; Data preservation dialog
  MessageBox MB_YESNO|MB_ICONQUESTION "Keep Your Naroapp Data?$\r$\n$\r$\nIncludes:$\r$\n  • Download history$\r$\n  • User profiles$\r$\n  • Settings$\r$\n$\r$\nYES = Keep data$\r$\nNO = Delete all" /SD IDYES IDYES KeepData
  
  DetailPrint "  ✓ Removing user data..."
  RMDir /r "$APPDATA\Naroapp"
  Goto DataHandled
  
  KeepData:
    DetailPrint "  ✓ User data preserved:"
    DetailPrint "    $APPDATA\Naroapp"
  
  DataHandled:
  
  DetailPrint "  ✓ Cleaning registry..."
  DeleteRegKey SHCTX "Software\Naroapp"
  
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  DetailPrint "  ✅ Uninstall Complete!"
  DetailPrint "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
!macroend

; ===================================================================
; 🎨 BRANDING
; ===================================================================

!macro customHeader
  BrandingText "Naroapp v${VERSION} • NaroTech India • www.naroapp.store"
!macroend

; ===================================================================
; 🎉 POST-INSTALL
; ===================================================================

!macro customFinish
  IfFileExists "$APPDATA\Naroapp\firstrun.txt" SkipFirstRun
    CreateDirectory "$APPDATA\Naroapp"
    FileOpen $0 "$APPDATA\Naroapp\firstrun.txt" w
    FileWrite $0 "Naroapp v${VERSION}$\r$\n"
    FileWrite $0 "First run: $DATE$\r$\n"
    FileClose $0
  SkipFirstRun:
!macroend

; ===================================================================
; END OF SAFE INSTALLER - NO CONFLICTS GUARANTEED
; ===================================================================